#include <iostream>
#include <vector>
#include <iostream>

inline long long f(long long x, long long y) {
    if (x == 0) return 0;
    return (x - 1) / y + 1;
}

void solve() {
    long long x, y;
    std::cin >> x >> y;
    std::cout << 2 * x - y << '\n';
}

const int SIZE = 1000;

int main() {
    std::cin.tie(nullptr)->sync_with_stdio(false);
    std::vector<int> w;
    for (int i = 1; i <= 9; i++) {
        w.push_back(i);
    }
    for (int i = 1; i <= 9; i++) {
        w.push_back(i * 11);
    }
    for (int i = 10; i <= 99; i++) {
        w.push_back(i * 10 + (i / 10));
    }
    std::vector<std::vector<int>> dp(w.size() + 1, std::vector<int>(SIZE + 1, 1000));
    dp[0][0] = 0;
    for (int i = 1; i <= w.size(); i++) {
        dp[i][0] = 0;
        for (int j = 1; j <= SIZE; j++) {
            if (w[i - 1] > j) {
                dp[i][j] = dp[i - 1][j];
                continue;
            }
            dp[i][j] = std::min(dp[i - 1][j], dp[i - 1][j - w[i - 1]] + 1);
        }
    }
    int t;
    std::cin >> t;
    while (t --> 0) {
        int n;
        std::cin >> n;
        std::cout << dp[w.size()][n] << '\n';
        //solve();
    }
    return 0;
}
